# Créé par admin, le 30/08/2023 en Python 3.7

import numpy as np

import matplotlib.pyplot as plt



#Données

m,u_m=         #valeur de la masse en g, incertitude sur la balance

V,u_V=         #valeur du volume en mL, incertitude sur la verrerie utilisée


def massevol(m,V):

    return(m/V)



#N tirages aléatoires selon la loi normale

def tirage_loiUniforme(X,u,N):

    return X+np.random.uniform(-u,u,N)



#Simulation

N=100000

m_sim=tirage_loiUniforme(m,u_m,N)

V_sim=tirage_loiUniforme(V,u_V,N)

massevol_sim=massevol(m_sim,V_sim)



#Calculs et affichages

moy=np.mean(massevol_sim)

ecartType=np.std(massevol_sim,ddof=1)



print("Masse volumique =",round(moy,3),"g/mL. L'incertitude type vaut",round(ecartType,3),"g/mL")

plt.hist(massevol_sim,bins='rice',edgecolor='black')

plt.title(str(N)+' simulations')

plt.xlabel("masse volumique (g/L)")

plt.ylabel('effectif')

plt.show()



